/*
 * Decompiled with CFR 0.152.
 */
package com.pikachu.mod.illager_more.entities;

import com.pikachu.mod.illager_more.CombatEvent;
import com.pikachu.mod.illager_more.entities.ai.AvoidAndApproachTargetGoal;
import com.pikachu.mod.illager_more.entities.projectile.BlastionerMarkProjectile;
import com.pikachu.mod.illager_more.entities.projectile.BlastionerProjectile;
import com.pikachu.mod.illager_more.init.ModEntityTypes;
import com.pikachu.mod.illager_more.init.ModItems;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class BlastionerEntity
extends AbstractIllager
implements IAnimatable {
    protected static final EntityDataAccessor<Boolean> IS_ATTACK = SynchedEntityData.m_135353_(BlastionerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> IS_SKILL = SynchedEntityData.m_135353_(BlastionerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> BEAM_LONG = SynchedEntityData.m_135353_(BlastionerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected int timer;
    protected int beamWeight;
    AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);

    public BlastionerEntity(EntityType<? extends AbstractIllager> p_32105_, Level p_32106_) {
        super(p_32105_, p_32106_);
        this.f_21364_ = 15;
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        return AbstractIllager.IllagerArmPose.NEUTRAL;
    }

    public boolean m_6469_(DamageSource p_37849_, float p_37850_) {
        if (this.timer > 50 && ((Boolean)this.f_19804_.m_135370_(IS_ATTACK)).booleanValue()) {
            return false;
        }
        if (this.timer > 42 && ((Boolean)this.f_19804_.m_135370_(IS_SKILL)).booleanValue()) {
            return false;
        }
        return super.m_6469_(p_37849_, p_37850_);
    }

    public boolean m_7307_(Entity p_33314_) {
        if (super.m_7307_(p_33314_)) {
            return true;
        }
        if (p_33314_ instanceof LivingEntity && ((LivingEntity)p_33314_).m_6336_() == MobType.f_21643_ || p_33314_ instanceof Raider) {
            return this.m_5647_() == null && p_33314_.m_5647_() == null;
        }
        return false;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12048_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12050_;
    }

    protected SoundEvent m_7975_(DamageSource p_32930_) {
        return SoundEvents.f_12051_;
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_12048_;
    }

    public void m_7895_(int p_32915_, boolean p_32916_) {
    }

    public void m_8119_() {
        if (this.f_19853_.m_5776_() && this.timer > 80 && this.timer <= 119) {
            for (int l = 0; l < this.beamWeight; ++l) {
                int i;
                Vec3 pos = CombatEvent.getOffsetPos((Entity)this, 0.0, 0.0, 1.25 + (double)(l + 3), this.f_20883_);
                for (i = 0; i < 2; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123810_, -0.75 + this.m_217043_().m_188500_() * 1.5 + pos.f_82479_, this.m_20187_(), -0.75 + this.m_217043_().m_188500_() * 1.5 + pos.f_82481_, 0.0, 0.0, 0.0);
                }
                if (!this.m_217043_().m_188499_()) continue;
                for (i = 0; i < 1; ++i) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_217043_().m_188500_() * 1.5 + pos.f_82479_, this.m_20187_(), this.m_217043_().m_188500_() * 1.5 + pos.f_82481_, 0.0, 0.0, 0.0);
                }
            }
        }
        super.m_8119_();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_37856_, DifficultyInstance p_37857_, MobSpawnType p_37858_, @Nullable SpawnGroupData p_37859_, @Nullable CompoundTag p_37860_) {
        this.populateDefaultEquipmentSlots();
        this.m_213946_(this.f_19796_, p_37857_);
        for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
            this.m_21409_(equipmentslot, 0.0f);
        }
        return super.m_6518_(p_37856_, p_37857_, p_37858_, p_37859_, p_37860_);
    }

    protected void populateDefaultEquipmentSlots() {
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ModItems.BLASTIONER_HELMET.get()));
        this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)ModItems.BLASTIONER_CHESTPLATE.get()));
        this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ModItems.BLASTIONER_LEGGINGS.get()));
        this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)ModItems.BLASTIONER_BOOTS.get()));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.325f).m_22268_(Attributes.f_22277_, 50.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 1.25);
    }

    public int getBeamWeight() {
        return (Integer)this.f_19804_.m_135370_(BEAM_LONG);
    }

    public void setBeamPos(BlockPos beamPos) {
    }

    public void setBeamWeight(int beamWeight) {
        this.f_19804_.m_135381_(BEAM_LONG, (Object)beamWeight);
        this.beamWeight = beamWeight;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ATTACK, (Object)false);
        this.f_19804_.m_135372_(IS_SKILL, (Object)false);
        this.f_19804_.m_135372_(BEAM_LONG, (Object)0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new AttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new Attack2Goal(this));
        this.f_21345_.m_25352_(5, new AvoidAndApproachTargetGoal<LivingEntity>((PathfinderMob)this, LivingEntity.class, 8.5f, 0.675, 1.1, true));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 7.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    private <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        event.getController().setAnimationSpeed(1.0);
        BlastionerEntity livingEntity = this;
        Vec3 velocity = livingEntity.m_20184_();
        float groundSpeed = Mth.m_14116_((float)((float)(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)));
        if (((Boolean)this.f_19804_.m_135370_(IS_ATTACK)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("attack", Boolean.valueOf(true)));
        } else if (((Boolean)this.f_19804_.m_135370_(IS_SKILL)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("attack2", Boolean.valueOf(true)));
        } else if (!(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
            event.getController().setAnimationSpeed(Math.max(Math.min((double)(groundSpeed * 20.0f), 2.1), 0.15));
            event.getController().setAnimation(new AnimationBuilder().addAnimation("walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    static class AttackGoal
    extends Goal {
        protected final BlastionerEntity mob;
        protected int cooldown;
        protected int projectileInt;
        protected List<LivingEntity> HitList = new ArrayList<LivingEntity>();

        public AttackGoal(BlastionerEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.mob = entity;
            this.cooldown = 0;
            this.projectileInt = 0;
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_8036_() {
            return this.mob.f_19797_ >= this.cooldown && this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && this.mob.m_142582_((Entity)this.mob.m_5448_()) && this.mob.m_20280_((Entity)this.mob.m_5448_()) > 6.0;
        }

        public boolean m_8045_() {
            return this.mob.timer <= 140;
        }

        public void m_8056_() {
            super.m_8056_();
            this.mob.f_19804_.m_135381_(IS_ATTACK, (Object)true);
            this.mob.m_5496_(SoundEvents.f_11868_, 1.0f, 1.0f);
            this.cooldown = this.mob.f_19797_ + 570;
            this.projectileInt = 0;
            this.mob.timer = 0;
            this.HitList = new ArrayList<LivingEntity>();
        }

        public void m_8037_() {
            Vec3 pos;
            int l;
            super.m_8037_();
            ++this.mob.timer;
            this.mob.m_21573_().m_26573_();
            for (l = 0; l < 32; ++l) {
                pos = CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.0, 1.25 + (double)(l + 1), this.mob.f_20883_);
                BlockPos blockPos = new BlockPos(Mth.m_14107_((double)pos.m_7096_()), Mth.m_14107_((double)pos.m_7098_()), Mth.m_14107_((double)pos.m_7094_()));
                this.mob.setBeamWeight(l);
                this.mob.setBeamPos(blockPos);
                if (this.mob.f_19853_.m_46859_(blockPos) || !this.mob.f_19853_.m_8055_(blockPos).m_60815_() || this.mob.f_19853_.m_46859_(blockPos.m_7918_(0, 1, 0)) || !this.mob.f_19853_.m_8055_(blockPos.m_7918_(0, 1, 0)).m_60815_()) continue;
                this.mob.setBeamWeight(l - 1);
                break;
            }
            if (this.mob.m_5448_() != null && this.mob.timer < 42) {
                this.mob.m_7618_(EntityAnchorArgument.Anchor.EYES, this.mob.m_5448_().m_20182_());
            } else {
                this.mob.m_20256_(Vec3.f_82478_);
            }
            if (this.mob.timer > 70 && this.mob.timer <= 109 && this.mob.m_217043_().m_188499_() && this.projectileInt < 10) {
                ++this.projectileInt;
                int max = this.mob.m_217043_().m_188503_(5) + 1;
                for (int i = 0; i < max; ++i) {
                    BlastionerProjectile mark = new BlastionerProjectile((EntityType<? extends AbstractHurtingProjectile>)((EntityType)ModEntityTypes.BLASTIONER_PROJECTILE.get()), this.mob.f_19853_);
                    Vec3 blockPos = CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 1.075, 1.25 + (double)this.mob.beamWeight, this.mob.f_20883_);
                    mark.settPos(blockPos);
                    Vec3 pos2 = CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.0, 1.25, this.mob.f_20883_);
                    mark.m_20219_(pos2);
                    Vec3 vec3 = new Vec3(this.mob.m_217043_().m_188583_() / 20.0, this.mob.m_217043_().m_188583_() / 15.0, this.mob.m_217043_().m_188583_() / 20.0);
                    mark.m_20256_(vec3);
                    mark.m_5602_((Entity)this.mob);
                    this.mob.f_19853_.m_7967_((Entity)mark);
                }
            }
            if (this.mob.timer > 80 && this.mob.timer < 120) {
                this.HitList = new ArrayList<LivingEntity>();
                for (l = 0; l < this.mob.beamWeight; ++l) {
                    pos = CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.0, 1.25 + (double)(l + 1), this.mob.f_20883_);
                    AABB aabb = new AABB(pos.m_7096_() - 0.75, pos.m_7098_(), pos.m_7094_() - 0.75, pos.m_7096_() + 0.75, pos.m_7098_() + 0.85, pos.m_7094_() + 0.75);
                    for (LivingEntity entityHit : this.mob.f_19853_.m_45976_(LivingEntity.class, aabb.m_82400_(0.65))) {
                        if (entityHit.m_7307_((Entity)this.mob) || this.HitList.contains(entityHit)) continue;
                        entityHit.f_19802_ = 0;
                        this.HitList.add(entityHit);
                        if (!entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob), 1.5f)) {
                            entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob).m_19380_(), CombatRules.m_19272_((float)1.5f, (float)entityHit.m_21230_(), (float)((float)entityHit.m_21133_(Attributes.f_22285_))));
                        }
                        entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob), 0.8f);
                        entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob), 1.2f);
                        entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob), 0.425f);
                        entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)this.mob), 1.35f);
                        entityHit.m_20256_(Vec3.f_82478_);
                        entityHit.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 80, 6));
                        entityHit.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 80, 4));
                        entityHit.m_7292_(new MobEffectInstance(MobEffects.f_19599_, 80, 5));
                    }
                }
            } else if (this.mob.timer == 79) {
                this.mob.m_216990_(SoundEvents.f_215750_);
            } else if (this.mob.timer == 60) {
                this.mob.m_216990_(SoundEvents.f_12054_);
            } else if (this.mob.timer == 42) {
                this.mob.m_216990_(SoundEvents.f_11867_);
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.HitList = new ArrayList<LivingEntity>();
            this.projectileInt = 0;
            this.mob.f_19804_.m_135381_(IS_ATTACK, (Object)false);
            this.mob.timer = 0;
        }

        public boolean m_183429_() {
            return true;
        }
    }

    static class Attack2Goal
    extends Goal {
        protected final BlastionerEntity mob;
        protected int cooldown;
        protected int projectileInt;

        public Attack2Goal(BlastionerEntity entity) {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
            this.mob = entity;
            this.cooldown = 0;
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_8036_() {
            return this.mob.f_19797_ >= this.cooldown && this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_() && this.mob.m_142582_((Entity)this.mob.m_5448_()) && this.mob.m_20280_((Entity)this.mob.m_5448_()) > 6.0;
        }

        public boolean m_8045_() {
            return this.mob.timer <= 100;
        }

        public void m_8056_() {
            super.m_8056_();
            this.mob.f_19804_.m_135381_(IS_SKILL, (Object)true);
            this.mob.m_5496_(SoundEvents.f_11868_, 1.0f, 1.0f);
            this.cooldown = this.mob.f_19797_ + 228;
            this.mob.timer = 0;
            this.projectileInt = 0;
        }

        public void m_8037_() {
            super.m_8037_();
            ++this.mob.timer;
            LivingEntity livingentity = this.mob.m_5448_();
            if (this.mob.m_5448_() != null && this.mob.timer < 42) {
                this.mob.m_7618_(EntityAnchorArgument.Anchor.EYES, this.mob.m_5448_().m_20182_());
            }
            this.mob.m_21573_().m_26573_();
            if (this.mob.timer == 68) {
                for (int o = 0; o < 6 - this.projectileInt; ++o) {
                    int max = this.mob.m_217043_().m_188503_(3) + 1;
                    for (int i = 0; i < max; ++i) {
                        BlastionerMarkProjectile mark = new BlastionerMarkProjectile((EntityType<? extends AbstractHurtingProjectile>)((EntityType)ModEntityTypes.BLASTIONER_MARK.get()), this.mob.f_19853_);
                        BlockPos blockPos = this.mob.m_20183_().m_7637_(-12.5 + (double)this.mob.f_19796_.m_188503_(25), 0.0, -12.5 + (double)this.mob.f_19796_.m_188503_(25));
                        for (int u = 0; u < 30; ++u) {
                            blockPos = !this.mob.f_19853_.m_46859_(blockPos) ? blockPos.m_7918_(0, 1, 0) : blockPos.m_7918_(0, -1, 0);
                        }
                        mark.settPos(blockPos);
                        Vec3 pos = CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.0, 1.25, this.mob.f_20883_);
                        mark.m_20219_(pos);
                        Vec3 vec3 = new Vec3(this.mob.m_217043_().m_188583_(), 1.25, this.mob.m_217043_().m_188583_());
                        mark.m_20256_(vec3);
                        mark.m_5602_((Entity)this.mob);
                        this.mob.f_19853_.m_7967_((Entity)mark);
                    }
                }
            }
            if (this.mob.timer > 67 && this.mob.timer <= 72) {
                if (this.mob.m_217043_().m_188499_() && this.projectileInt < 6) {
                    ++this.projectileInt;
                    int max = this.mob.m_217043_().m_188503_(3) + 1;
                    for (int i = 0; i < max; ++i) {
                        Vec3 vec3;
                        Vec3 pos;
                        BlockPos blockPos;
                        BlastionerMarkProjectile mark;
                        if (this.mob.timer > 68) {
                            mark = new BlastionerMarkProjectile((EntityType<? extends AbstractHurtingProjectile>)((EntityType)ModEntityTypes.BLASTIONER_MARK.get()), this.mob.f_19853_);
                            blockPos = livingentity != null ? livingentity.m_20183_().m_7637_(-6.5 + (double)this.mob.f_19796_.m_188503_(13), 0.0, -6.5 + (double)this.mob.f_19796_.m_188503_(13)) : this.mob.m_20183_().m_7637_(-12.5 + (double)this.mob.f_19796_.m_188503_(25), 0.0, -12.5 + (double)this.mob.f_19796_.m_188503_(25));
                            for (int u = 0; u < 30; ++u) {
                                blockPos = !this.mob.f_19853_.m_46859_(blockPos) ? blockPos.m_7918_(0, 1, 0) : blockPos.m_7918_(0, -1, 0);
                            }
                            mark.settPos(blockPos);
                            pos = CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.0, 1.25, this.mob.f_20883_);
                            mark.m_20219_(pos);
                            vec3 = new Vec3(this.mob.m_217043_().m_188583_(), 1.5, this.mob.m_217043_().m_188583_());
                            mark.m_20256_(vec3);
                            mark.m_5602_((Entity)this.mob);
                            this.mob.f_19853_.m_7967_((Entity)mark);
                            continue;
                        }
                        mark = new BlastionerMarkProjectile((EntityType<? extends AbstractHurtingProjectile>)((EntityType)ModEntityTypes.BLASTIONER_MARK.get()), this.mob.f_19853_);
                        blockPos = this.mob.m_20183_().m_7637_(-12.5 + (double)this.mob.f_19796_.m_188503_(25), 0.0, -12.5 + (double)this.mob.f_19796_.m_188503_(25));
                        for (int u = 0; u < 30; ++u) {
                            blockPos = !this.mob.f_19853_.m_46859_(blockPos) ? blockPos.m_7918_(0, 1, 0) : blockPos.m_7918_(0, -1, 0);
                        }
                        mark.settPos(blockPos);
                        pos = CombatEvent.getOffsetPos((Entity)this.mob, 0.0, 0.0, 1.25, this.mob.f_20883_);
                        mark.m_20219_(pos);
                        vec3 = new Vec3(this.mob.m_217043_().m_188583_(), 1.25, this.mob.m_217043_().m_188583_());
                        mark.m_20256_(vec3);
                        mark.m_5602_((Entity)this.mob);
                        this.mob.f_19853_.m_7967_((Entity)mark);
                    }
                }
            } else if (this.mob.timer != 64) {
                if (this.mob.timer == 55) {
                    this.mob.m_5496_(SoundEvents.f_12054_, 1.0f, 1.0f);
                } else if (this.mob.timer == 42) {
                    this.mob.m_5496_(SoundEvents.f_11867_, 1.0f, 1.0f);
                }
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.mob.f_19804_.m_135381_(IS_SKILL, (Object)false);
            this.mob.timer = 0;
            this.projectileInt = 0;
        }

        public boolean m_183429_() {
            return true;
        }
    }
}

